<?php

declare(strict_types=1);

namespace OCA\SpeakchatApi\Controller;

use OCP\AppFramework\Http\ContentSecurityPolicy;
use OCP\AppFramework\Http\FeaturePolicy;
use OCA\SpeakchatApi\AppInfo\Application;
use OCP\AppFramework\Controller;
use OCP\AppFramework\Http\Attribute\FrontpageRoute;
use OCP\AppFramework\Http\Attribute\NoAdminRequired;
use OCP\AppFramework\Http\Attribute\NoCSRFRequired;
use OCP\AppFramework\Http\Attribute\OpenAPI;
use OCP\AppFramework\Http;
use OCP\AppFramework\Http\TemplateResponse;
use OCP\AppFramework\Http\DataResponse;
use OCP\AppFramework\Http\Response;
use OCP\IRequest;
use OCP\IUserSession;
use OCP\Server;
use OCP\IURLGenerator;
use OCP\IUserManager;
use OCP\Accounts\IAccountManager;
use OCP\AppFramework\Services\IInitialState;
use OCP\IConfig;

/**
 * @psalm-suppress UnusedClass
 */
class PageController extends Controller {
	
	/**
	 * @var IAccountManager
	 */

	public function __construct(
			string $AppName,
			IRequest $request,
			IUserSession $userSession,
			IURLGenerator $urlGenerator,
			IUserManager $userManager,
			IAccountManager $accountManager,
			IInitialState $initialState,
            IConfig $config,
		) {
			parent::__construct($AppName, $request);
			$this->userSession = $userSession;
			$this->urlGenerator = $urlGenerator;
			$this->userManager = $userManager;
			$this->accountManager = $accountManager;
			$this->initialState = $initialState;
			$this->config = $config;
		}
	
	#[NoCSRFRequired]
	#[NoAdminRequired]
	#[OpenAPI(OpenAPI::SCOPE_IGNORE)]
	#[FrontpageRoute(verb: 'GET', url: '/')]
	public function index(): TemplateResponse {

        $yclientLinkApp = $this->config->getAppValue(Application::APP_ID, 'yclients_link_market', '');
        $this->initialState->provideInitialState('yclients_link_market', $yclientLinkApp);

		$response = new TemplateResponse(
			Application::APP_ID,
			'index',
		);
		
		$csp = new ContentSecurityPolicy();
		$csp->addAllowedImageDomain('*');
		
		$response->setContentSecurityPolicy($csp);
		
		return $response;
	}
}
