<?php

declare(strict_types=1);

namespace OCA\SpeakchatApi\Db;

use JsonSerializable;
use OCP\AppFramework\Db\Entity;

/**
 * Class Integration
 *
 * @method string getName()
 * @method void   setName(string $name)
 * @method string getCreatorId()
 * @method void   setCreatorId(string $creatorId)
 * @method string getApiId()
 * @method void   setApiId(string $apiId)
 * @method string getKeyApi()
 * @method void   setKeyApi(string $keyApi)
 * @method string getStatus()
 * @method void   setStatus(string $status)
 * @method string getIntegrationType()
 * @method void   setIntegrationType(string $integrationType)
 * @method int    getNumberOfUsers()
 * @method void   setNumberOfUsers(int $numberOfUsers)
 * @method int    getReminderEmailSent()
 * @method void   setReminderEmailSent(int $reminderEmailSent)
 * @method int    getExpirationEmailSent()
 * @method void   setExpirationEmailSent(int $expirationEmailSent)
 * @method string getExpDate()
 * @method void   setExpDate(string $expDate)
 */
class Integration extends Entity implements JsonSerializable {
	/**
	 * @var string
	 */
	protected $name;

	/**
	 * @var string
	 */
	protected $creatorId;

	/**
	 * @var string
	 */
	protected $apiId;

	/**
	 * @var string
	 */
	protected $keyApi;

	/**
	 * @var string
	 */
	protected $status;

	/**
	 * @var string
	 */
	protected $integrationType;

	/**
	 * @var int
	 */
	protected $numberOfUsers;

	/**
	 * @var int
	 */
	protected $reminderEmailSent;

	/**
	 * @var int
	 */
	protected $expirationEmailSent;

	/**
	 * @var string
	 */
	protected $expDate;

	public function __construct() {
		$this->addType('id', 'integer');
	}


	/**
	 * @return array<string, mixed>
	 */
	public function jsonSerialize(): array {
		return [
			'id' => $this->getId(),
			'name' => $this->getName(),
			'creatorId' => $this->getCreatorId(),
			'apiId' => $this->getApiId(),
			'keyApi' => $this->getKeyApi(),
			'status' => $this->getStatus(),
			'typeIntegration' => $this->getIntegrationType(),
			'expDate' => $this->getExpDate(),
			'numberOfUsers' => $this->getNumberOfUsers(),
			'reminderEmailSent' => $this->getReminderEmailSent(),
			'expirationEmailSent' => $this->getExpirationEmailSent(),
		];
	}
}
