<?php
declare(strict_types=1);

namespace OCA\SpeakchatApi\Service;

interface HttpClientInterface
{
    /**
     * Sendet eine HTTP-Anfrage (GET, POST, PUT, DELETE)
     *
     * @param string $method
     * @param string $path
     * @param array|null $body
     * @return array
     */
    public function request(string $method, string $path, ?array $body = null): array;

    /**
     * Sendet eine POST-Anfrage an die angegebene URL
     *
     * @param string $url
     * @param string $authToken
     * @param string|null $payload
     * @return array
     */
    public function sendPostRequest(string $url, string $authToken, ?string $payload): array;
}
