<?php

declare(strict_types=1);

namespace OCA\SpeakchatApi\Settings;

use OCA\SpeakchatApi\AppInfo\Application;
use OCP\IURLGenerator;
use OCP\Settings\IIconSection;

class AdminSection implements IIconSection {
    /** @var IURLGenerator */
    private $urlgen;

    public function __construct(IURLGenerator $urlgen) {
        $this->urlgen = $urlgen;
    }

    public function getIcon(): string {
        return $this->urlgen->imagePath('speakchatapi', 'app-dark.svg');
    }

    public function getID(): string {
        return Application::APP_ID;
    }

    public function getName(): string {
        return 'speakchatapi';
    }

    public function getPriority(): int {
        return 80;
    }
}
