<?php

declare(strict_types=1);

/**
 * Background reminder job
 */

namespace OCA\SpeakchatApi\BackgroundJob;

use OCA\SpeakchatApi\Service\ReminderExpirationService;
use OCP\AppFramework\Utility\ITimeFactory;
use OCP\BackgroundJob\TimedJob;

class Reminder extends TimedJob {
    private const INTERVAL_TIME_SECOND = 60;
    public function __construct(
		ITimeFactory $time,
		protected ReminderExpirationService $reminderExpirationService,
	) {
		parent::__construct($time);
		// Every minute
		$this->setInterval(self::INTERVAL_TIME_SECOND);
	}

	/**
	 * @inheritDoc
	 */
	protected function run($argument): void {
		$this->reminderExpirationService->executeReminders($this->time->getDateTime());
	}
}
