<?php

declare(strict_types=1);

namespace OCA\SpeakchatApi\Db;

use OCP\AppFramework\Db\QBMapper;
use OCP\IDBConnection;
use OCP\IUser;

use function reset;

/**
 * @extends QBMapper<Integration>
 */
class IntegrationMapper extends QBMapper {
	public function __construct(IDBConnection $db) {
		parent::__construct($db, 'speakchat_integration', Integration::class);
	}

	public function findAllByCreator(IUser $user): array {
		return $this->findAllByCreatorId($user->getUID());
	}
	
	public function findAllByCreatorId(string $userId): array {
		$qb = $this->db->getQueryBuilder();

		$qb->select('*')
			->from($this->getTableName())
			->where(
				$qb->expr()->eq('creator_id', $qb->createNamedParameter($userId))
			)
			->orderBy('name', 'asc');

		return $this->findEntities($qb);
	}

    /**
     * @return Integration|null
     */
    public function findByApiId(string $apiId): ?Integration{
      	return $this->findOneBy('api_id', $apiId);
    }

    public function findById(int $id): ?Integration{
      	return $this->findOneBy('id', $id);
    }

	/**
	 * @param string $column
	 * @param mixed $value
	 * @return Room|null
	 */
	private function findOneBy(string $column, $value): ?Integration {
		$qb = $this->db->getQueryBuilder();

		$qb->select('*')
			->from($this->getTableName())
			->where(
				$qb->expr()->eq($column, $qb->createNamedParameter($value))
			);

		$integration = $this->findEntities($qb);
		return empty($integration) ? null : reset($integration);
	}


	/**
	 * @param inetger $offset - the offset of the list
	 * @param inetger $pageSize - the nambe of lics in one page
	 * @return array<Lic>
	 */
	public function getIntegrations($offset, $pageSize): array {
		$qb = $this->db->getQueryBuilder();

		$qb->select('*')
			->from($this->getTableName())
			->setMaxResults($pageSize)
	        ->setFirstResult($offset);

		return $this->findEntities($qb);
	}
}
