<?php

declare(strict_types=1);

namespace OCA\SpeakchatApi\Migration;

use Closure;
use Doctrine\DBAL\Schema\SchemaException;
use OCP\DB\ISchemaWrapper;
use OCP\Migration\IOutput;
use OCP\Migration\SimpleMigrationStep;

class Version10001Date20252005 extends SimpleMigrationStep {
	/**
	 * @param IOutput $output
	 * @param Closure $schemaClosure
	 * @param array<mixed> $options
	 * @return ISchemaWrapper
	 * @throws SchemaException
	 */
	public function changeSchema(
		IOutput $output,
		Closure $schemaClosure,
		array $options
	) {
		/** @var ISchemaWrapper $schema */
		$schema = $schemaClosure();

		$table = $schema->createTable('speakchat_integration');
		$table->addColumn(
			'id',
			'integer',
			[
				'autoincrement' => true,
				'notnull' => true,
			]
		);
		$table->addColumn(
			'name',
			'string',
			[
				'notnull' => true,
				'length' => 255,
			]
		);
		$table->addColumn(
    		'creator_id',
       		'string',
    		[
   				'notnull' => true,
    			'length' => 255,
  			]
  		);
		$table->addColumn(
			'api_id',
			'string',
			[
				'notnull' => true,
				'length' => 255,
			]
		);
		$table->addColumn(
			'key_api',
			'string',
			[
				'notnull' => true,
				'length' => 255,
			]
		);
		$table->addColumn(
			'status',
			'string',
			[
				'notnull' => true,
				'length' => 255,
			]
		);

		$table->addColumn(
			'integration_type',
			'string',
			[
			 	'notnull' => false,
			]
		);

		$table->addColumn(
    		'exp_date',
    		'string',
    		[
    		 	'notnull' => false,
    		]
    	);

    	$table->addColumn(
       		'number_of_users',
       		'integer',
       		[
       		 	'notnull' => false,
                'default' => 1,
            ]
       	);

        $table->addColumn(
            'reminder_email_sent',
            'integer',
            [
                'notnull' => false,
                'default' => 0,
            ]
        );

        $table->addColumn(
            'expiration_email_sent',
            'integer',
            [
                'notnull' => false,
                'default' => 0,
            ]
        );

		$table->setPrimaryKey(['id']);
		return $schema;
	}
}
